---
title: CAs and edge certificates FAQ · Cloudflare SSL/TLS docs
description: Get answers to commonly asked questions about the certificates you
  can obtain through Cloudflare and the CAs that Cloudflare partners with.
lastUpdated: 2025-07-17T10:06:59.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/troubleshooting/ca-faq/
  md: https://developers.cloudflare.com/ssl/edge-certificates/troubleshooting/ca-faq/index.md
---

Refer to this page for frequently asked questions about Cloudflare SSL/TLS certificate offerings and the CAs that Cloudflare partners with.

## General

### Does Cloudflare issue both RSA and ECDSA certificates?

Yes. Cloudflare can issue both RSA and ECDSA certificates.

## Certificate authorities (CAs)

### Which certificate authorities does Cloudflare use?

Cloudflare uses Let's Encrypt, Google Trust Services, SSL.com, and Sectigo. You can see a complete list of products and available CAs and algorithms in the [certificate authorities reference page](https://developers.cloudflare.com/ssl/reference/certificate-authorities/).

Sectigo is only used for [backup certificates](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/).

### Are there any CA limitations I should know about?

You can find a list of limitations for every CA in our pipeline in the [certificate authorities reference page](https://developers.cloudflare.com/ssl/reference/certificate-authorities/).

### What clients are supported by the CAs that Cloudflare offers?

In the [certificate authorities reference page](https://developers.cloudflare.com/ssl/reference/certificate-authorities/), you can find information about device and browser compatibility.

### I do not want to use one of the CAs that Cloudflare partners with. What can I do?

If you are on a Business or Enterprise plan, you can [upload a certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/#upload-a-custom-certificate) from the CA of your choice.

### What CAA records do I need in order to allow issuance from Cloudflare CAs?

You can find CAA records associated with every Cloudflare CA in the [certificate authorities reference page](https://developers.cloudflare.com/ssl/reference/certificate-authorities/#caa-records). If you are using Cloudflare as your DNS provider, then the CAA records will be added on your behalf.

### I am missing the CAs that Cloudflare uses in my trust store. What should I do?

You can use Cloudflare [CFSSL trust store](https://github.com/cloudflare/cfssl_trust), which includes all of the CAs that are used by Cloudflare managed certificates.

## Universal SSL

### I am using Universal SSL and I would like to use a different CA. How can I do that?

To be able to specify a CA, you must purchase [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/). Through Advanced Certificate Manager, you can choose the certificate authority when ordering an advanced certificate or you can choose a default CA when using [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/).

If you are on a Business or Enterprise plan, you can [upload a certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/#upload-a-custom-certificate) from the CA of your choice. In this case, certificate issuance and renewal will have to be managed by you.

### Does Cloudflare issue both RSA and ECDSA certificates for Universal certificates?

Universal certificates on free zones only receive an ECDSA certificate. Paid zones receive an RSA and ECDSA certificate.

## Advanced Certificate Manager

### How can I choose which CA will be used for my certificates?

When [ordering an advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/), you can choose the CA through the UI or API.

[Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/) allows you to get full certificate coverage. When enabling Total TLS, you can choose the CA that will be used for all Total TLS certificates.

## Renewal

### Error when clicking `Approve Certificate` on a Certificate Approval renewal email

The full error message is: `An error occurred while attempting to validate your domain. Please try again later or contact support for assistance.`

Check the status of the certificate on the [Cloudflare dashboard](https://dash.cloudflare.com?to=/:account/:zone/ssl-tls). If the status is `Active`, you can disregard this email and the error message.
