---
title: Speed · Cloudflare Speed docs
description: Speed allows you to assess the performance of your website and get
  recommendations of Cloudflare products to enhance the website performance.
lastUpdated: 2025-09-26T10:03:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/
  md: https://developers.cloudflare.com/speed/index.md
---

Improve the performance of your website or web application.

Available on all plans

Speed allows you to assess the performance of your website and get recommendations of Cloudflare products to enhance the website performance.

***

## Features

### Observatory

Use Observatory to conduct tests with both synthetic and real user data to identify potential website performance enhancements.

[Use Observatory](https://developers.cloudflare.com/speed/observatory/)

### Settings

Get recommendations of Cloudflare products and settings to improve your website’s performance.

[Use Settings](https://developers.cloudflare.com/speed/optimization/)

### Aggregated Internet Measurement

Understand your Internet quality to identify scenarios that your Internet connection is good or bad for.

[Use Aggregated Internet Measurement](https://developers.cloudflare.com/speed/aim/)

***

## Related products

**[Cache rules](https://developers.cloudflare.com/cache/how-to/cache-rules/)**

Customize the cache properties of your HTTP requests.

**[Cloudflare Web Analytics](https://developers.cloudflare.com/web-analytics/)**

Understand the performance of your webpages as experienced by your site visitors.

**[Cloudflare Image Resizing](https://developers.cloudflare.com/images/transform-images/)**

Transform images on Cloudflare's edge platform: resize, adjust quality, and convert images to WebP or AVIF format on demand.

**[Early Hints](https://developers.cloudflare.com/cache/advanced-configuration/early-hints/)**

Take advantage of "server think time" to asynchronously send instructions to the browser to begin loading resources while the origin server is compiling the full response.

***

## More resources

[Quotas](https://developers.cloudflare.com/speed/observatory/run-speed-test/#quotas)

Learn about the quota limits for the number of tests you can run per month.

[Community Forum](https://community.cloudflare.com/c/website-application-performance/88)

Engage with other users and explore more resources on Cloudflare support forum.
