---
title: Set response header with a static value · Cloudflare Rules docs
description: Create a response header transform rule (part of Transform Rules)
  to set an `X-Bot-Score` HTTP header in the response to a static value
  (`Cloudflare`).
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/set-response-header-static-value/
  md: https://developers.cloudflare.com/rules/transform/examples/set-response-header-static-value/index.md
---

The following response header transform rule sets a header named `X-Source` to a static value (`Cloudflare`) in the HTTP response:

Text in **Expression Editor**:

```txt
starts_with(http.request.uri.path, "/en/")
```

Selected operation under **Modify response header**: *Set static*

**Header name**: `X-Source`

**Value**: `Cloudflare`

This rule would overwrite any existing `X-Source` headers already present in the HTTP response.
