---
title: Manage datasets · Cloudflare Log Explorer docs
description: Log Explorer allows you to enable or disable which datasets are
  available to query in Log Search.
lastUpdated: 2025-11-18T15:34:25.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/log-explorer/manage-datasets/
  md: https://developers.cloudflare.com/log-explorer/manage-datasets/index.md
---

Log Explorer allows you to enable or disable which datasets are available to query in Log Search.

## Supported datasets

Log Explorer currently supports the following datasets:

### Zone level

* [HTTP Requests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/http_requests/) (`http_requests`)
* [Firewall Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/firewall_events/) (`firewall_events`)
* [DNS Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/dns_logs/) (`dns_logs`)
* [NEL Reports](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/nel_reports/) (`nel_reports`)
* [Page Shield Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/page_shield_events/) (`page_shield_events`)
* [Spectrum Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/spectrum_events/) (`spectrum_events`)
* [Zaraz Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/zone/zaraz_events/) (`zaraz_events`)

### Account level

* [Access requests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/access_requests/) (`access_requests`)
* [CASB findings](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/casb_findings/) (`casb_findings`)
* [Device posture results](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/device_posture_results/) (`device_posture_results`)
* [Gateway DNS](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_dns/) (`gateway_dns`)
* [Gateway HTTP](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_http/) (`gateway_http`)
* [Gateway Network](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_network/) (`gateway_network`)
* [Zero Trust Network Session Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/) (`zero_trust_network_sessions`)
* [Audit Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs/) (`audit_logs`)
* [Audit\_logs\_v2](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs_v2/) (`audit_logs_v2`)
* [Browser Isolation User Actions](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/biso_user_actions/) (`biso_user_actions`)
* [DNS firewall logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dns_firewall_logs/) (`dns_firewall_logs`)
* [Email security alerts](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/email_security_alerts/) (`email_security_alerts`)
* [Magic IDS Detections](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/magic_ids_detections/) (`magic_ids_detections`)
* [Network Analytics](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/network_analytics_logs/) (`network_analytics_logs`)
* [Sinkhole HTTP Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/sinkhole_http_logs/) (`sinkhole_http_logs`)
* [IP Sec Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/ipsec_logs/) (`ipsec_logs`)

## Enable Log Explorer

In order for Log Explorer to begin storing logs, you need to enable the desired datasets. You can do this via the dashboard or the API.

1. In the Cloudflare dashboard, go to the **Log Explorer** > **Manage datasets** page.

   [Go to **Manage datasets**](https://dash.cloudflare.com/?to=/:account/log-explorer/manage-sources)

2. Select **Add dataset** to select the datasets you want to query.

3. Choose a dataset and then a zone. Then, select **Add**. You can always return to this page to enable more datasets or manage your existing ones.

Note

It may take a few minutes for the logs to become available for querying.

If you are using the API, Use the Log Explorer API to enable Log Explorer for each dataset you wish to store. It may take a few minutes after a log stream is enabled before you can view the logs.

The following `curl` command is an example for enabling the zone-level dataset `http_requests`, as well as the expected response when the command succeeds.

```bash
curl https://api.cloudflare.com/client/v4/zones/{zone_id}/logs/explorer/datasets \
--header "Authorization: Bearer <API_TOKEN>" \
--json '{
  "dataset": "http_requests"
}'
```

```json
{
  "result": {
    "dataset": "http_requests",
    "object_type": "zone",
    "object_id": "<ZONE ID>",
    "created_at": "2025-06-03T14:33:16Z",
    "updated_at": "2025-06-03T14:33:16Z",
    "dataset_id": "01973635f7e273a1964a02f4d4502499",
    "enabled": true
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

To enable an account-level dataset, replace `zones/{zone_id}` with `accounts/{account_id}` in the `curl` command. For example:

```bash
curl https://api.cloudflare.com/client/v4/accounts/{account_id}/logs/explorer/datasets \
--header "Authorization: Bearer <API_TOKEN>" \
--json '{
  "dataset": "access_requests"
}'
```
