---
title: Rule categories — Network-layer DDoS · Cloudflare DDoS Protection docs
description: "The main categories (or tags) of Network-layer DDoS Attack
  Protection managed rules are the following:"
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/rule-categories/
  md: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/rule-categories/index.md
---

The main categories (or tags) of Network-layer DDoS Attack Protection managed rules are the following:

| Name | Description |
| - | - |
| `gre` | Rules for DDoS attacks over Generic Routing Encapsulation (GRE) that usually target GRE endpoints. |
| `esp` | Rules for DDoS attacks related to the Encapsulating Security Payload (ESP) protocol, which is part of the IPsec secure network protocol suite. |
| `advanced` | Rules related to features available to Enterprise customers, such as [Adaptive DDoS Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/adaptive-protection/). |
| `generic` | Rules for detecting and mitigating floods of packets. These rules are useful for mitigating attacks that have no known signatures, but they may also trigger on unusually high volumes of legitimate traffic. To reduce the risk of false positives, their packet per second (pps) activation threshold is higher. These rules rate-limit traffic by default, but you can override them to block traffic if necessary. |
| `read-only` | Highly targeted rules for mitigating DDoS attacks with a high confidence rate. These rules are read-only — you cannot override their sensitivity level or action. |
| `test` | Rules used for testing the detection, mitigation, and alerting capabilities of Cloudflare's DDoS protection products. |

There are other rule categories based on the attack vector/protocol, such as `dns`, `quic`, and `sip`. The categories list is dynamic and may change over time.
