---
title: Non-identity on-ramps · Cloudflare One docs
description: With Cloudflare One, you can isolate HTTP traffic from on-ramps
  such as proxy endpoints or Magic WAN. Since these on-ramps do not require
  users to log in to Cloudflare WARP, identity-based policies are not supported.
lastUpdated: 2025-11-21T18:29:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/non-identity/
  md: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/non-identity/index.md
---

With Cloudflare One, you can isolate HTTP traffic from on-ramps such as [proxy endpoints](https://developers.cloudflare.com/cloudflare-one/networks/resolvers-and-proxies/proxy-endpoints/) or [Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/). Since these on-ramps do not require users to log in to Cloudflare WARP, [identity-based policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/) are not supported.

Note

If you want to apply Isolate policies based on user identity, you will need to either install the [WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) or manually redirect users to the [Clientless Web Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/) URL.

## Set up non-identity browser isolation

1. [Install a Cloudflare certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) on your devices.

2. Connect your infrastructure to Gateway using one of the following on-ramps:

   * Configure your browser to forward traffic to a Gateway proxy endpoint with [PAC files](https://developers.cloudflare.com/cloudflare-one/networks/resolvers-and-proxies/proxy-endpoints/).
   * Connect your enterprise site router to Gateway with the [anycast GRE or IPsec tunnel on-ramp to Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/).

3. Enable non-identity browser isolation:

   1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Browser isolation** > **Browser isolation settings**.
   2. Turn on **Allow isolated HTTP traffic when user identity is unknown**.

4. Build a non-identity [HTTP policy](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/) to isolate websites in a remote browser.
