---
title: Generic SAML 2.0 · Cloudflare One docs
description: Cloudflare One integrates with any identity provider that supports
  SAML 2.0. If your identity provider is not listed in the integration list of
  login methods in Cloudflare One, it can be configured using SAML 2.0 (or
  OpenID if OIDC based). Generic SAML can also be used if you would like to pass
  additional SAML headers or claims for an IdP in the integration list.
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/index.md
---

Cloudflare One integrates with any identity provider that supports SAML 2.0. If your identity provider is not listed in the integration list of login methods in Cloudflare One, it can be configured using SAML 2.0 (or OpenID if OIDC based). Generic SAML can also be used if you would like to pass additional SAML headers or claims for an IdP in the integration list.

## Prerequisites

Minimum requirements for identity providers:

* The IdP must conform to SAML 2.0.
* The IdP must provide a **Single sign-on URL**, an **Entity ID or Issuer URL**, and a **Signing certificate**.
* The IdP must include the signing public key in the SAML response.

## 1. Create an application in your identity provider

Most identity providers allow users to create an **Application**. In this context, an application is a set of parameters that the identity provider will then pass on to Cloudflare to establish an integration.

The typical setup requirements are:

1. Create a new integration in the identity provider with the type set as **SAML**.

2. Set both the **Entity/Issuer ID** and the **Single sign-on URL** to:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com) under **Settings** > **Team name**.

3. Set the **Name ID/Email format** to `emailAddress`.

4. (Optional) Set the signature policy to *Always Sign*.

### (Optional) Upload SAML metadata

If your identity provider supports metadata file configuration, you can use the default or identity provider specific metadata endpoint:

* **Default:** `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/saml-metadata`
* **Identity provider specific:** `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/<identity-provider-id>/saml-metadata`, where `<identity-provider-id>` is the `id` value obtained from [List Access identity providers](https://developers.cloudflare.com/api/resources/zero_trust/subresources/identity_providers/methods/list/). Use this endpoint if your IdP requires a configuration not defined in the default metadata file.

To download the SAML metadata file, copy-paste the metadata endpoint into a web browser and save the page as an `.xml` file. Upload this XML file to the identity provider.

## 2. Add a SAML identity provider to Cloudflare One

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.
  2. Select **Add new identity provider** and select **SAML**.
  3. Choose a descriptive name for your identity provider.
  4. Enter the **Single Sign on URL**, **IdP Entity ID or Issuer URL**, and **Signing certificate** obtained from your identity provider.
  5. (Optional) To enable SCIM, refer to [Synchronize users and groups](#synchronize-users-and-groups).
  6. (Optional) Under **Optional configurations**, configure [additional SAML options](#optional-configurations).
  7. Select **Save**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Organizations, Identity Providers, and Groups Write`

  2. Configure the [`cloudflare_zero_trust_access_identity_provider`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_identity_provider) resource:

     ```tf
     resource "cloudflare_zero_trust_access_identity_provider" "generic_saml_example" {
       account_id = var.cloudflare_account_id
       name       = "Generic SAML example"
       type       = "saml"
       config      = {
         sso_target_url = "https://example.com/1234/sso/saml"
         issuer_url = "https://example.com/1234"
         idp_public_certs = ["-----BEGIN CERTIFICATE-----\nXXXXX\n-----END CERTIFICATE-----"]
         sign_request = false
         email_attribute_name = "email"
         attributes = ["employeeID", "groups"]
       }
     }
     ```

Warning

Set a reminder for the expiry date of the signing certificate obtained from your generic SAML identity provider. After the certificate expires, you will need to generate a new signing certificate and re-add it to your Cloudflare configuration via the Cloudflare dashboard or Terraform.

## 3. Test the connection

You can now [test the IdP integration](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/#test-idps-in-cloudflare-one). A success response should return the configured SAML attributes.

## Synchronize users and groups

The generic SAML integration allows you to synchronize user groups and automatically deprovision users using [SCIM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/).

### Prerequisites

Your identity provider must support SCIM version 2.0.

### 1. Enable SCIM in Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.

2. Find the IdP integration and select **Edit**.

3. Turn on **Enable SCIM**

4. (Optional) Configure the following settings:

* **Enable user deprovisioning**: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/#per-user) when they are removed from the SCIM application in IdP. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/).

* **Remove user seat on deprovision**: [Remove a user's seat](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/) from your Cloudflare One account when they are removed from the SCIM application in IdP.

* **SCIM identity update behavior**: Choose what happens in Cloudflare One when the user's identity updates in IdP.

  * *Automatic identity updates*: Automatically update the [User Registry identity](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/users/) when IdP sends an updated identity or group membership through SCIM. This identity is used for Gateway policies and WARP [device profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/); Access will read the user's updated identity when they reauthenticate.
  * *Group membership change reauthentication*: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/#per-user) when their group membership changes in IdP. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/). Access will read the user's updated group membership when they reauthenticate.
  * *No action*: Update the user's identity the next time they reauthenticate to Access or WARP.

1. Select **Regenerate Secret**. Copy the **SCIM Endpoint** and **SCIM Secret**. You will need to enter these values into IdP.

2. Select **Save**.

The SCIM secret never expires, but you can manually regenerate the secret at any time.

### 2. Configure SCIM in the IdP

Setup instructions vary depending on the identity provider. In your identity provider, you will either need to edit the [original SSO application](#1-create-an-application-in-your-identity-provider) or create a new SCIM application. Refer to your identity provider's documentation for more details. For example instructions, refer to our [Okta](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta/#synchronize-users-and-groups) or [JumpCloud](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/jumpcloud-saml/#synchronize-users-and-groups) guides.

#### IdP groups

If you would like to build policies based on IdP groups:

* Ensure that your IdP sends a `groups` field. The naming must match exactly (case insensitive). All other values will be sent as a SAML attribute.
* If your IdP requires creating a new SCIM application, ensure that the groups in the SCIM application match the groups in the [original SSO application](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#1-create-an-application-in-your-identity-provider). Because SCIM group membership updates will overwrite any groups in a user's identity, assigning the same groups to each app ensures consistent policy evaluation.

### 3. Verify SCIM provisioning

To check if user identities were updated in Cloudflare One, view your [SCIM provisioning logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/).

Note

New users must first [register the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/) or authenticate to an Access application before SCIM provisioning can begin.

## Optional configurations

SAML integrations allow you to pass additional headers or claims to applications.

### Sign SAML authentication request

This optional configuration signs the [Access JWT](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/) with the Cloudflare Access public key to ensure that the JWT is coming from a legitimate source. The Cloudflare public key can be obtained at `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/certs`.

### Email attribute name

Many [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) depend on a user's email address. Some identity providers have a different naming for the email address attribute (for example, `Email`, `e-mail`, `emailAddress`). This can typically be checked in the identity provider's SAML test option.

Example in Okta:

![Preview the SAML assertion from the Okta dashboard](https://developers.cloudflare.com/_astro/saml-assertion.z-CnJcdz_ZwpCxn.webp)![Determine the email attribute name from the SAML assertion](https://developers.cloudflare.com/_astro/saml-attributes.B1LfosVi_uuOI7.webp)

### SAML headers and attributes

Cloudflare Access supports SAML (Security Assertion Markup Language) attributes and SAML headers for all SAML IdP integrations.

[**SAML attributes**](#saml-attributes) refer to specific data points or characteristics that the IdP shares about the authenticated user. These attributes often include details like email address, name, or role, and are passed along to the service provider upon successful authentication.

[**SAML headers**](#saml-headers) are metadata in the SAML protocol communication which convey information about the sender, recipient, and the message itself. These headers can be leveraged to provide extra context or control over the communication.

#### SAML attributes

SAML attributes are added to the [Access JWT](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/). These attributes can then be consumed by self-hosted or SaaS applications connected to Access. Any SAML attribute configured in the SAML integration must also be sent from the IdP.

Example in Okta:

![Configure Okta to send SAML attributes](https://developers.cloudflare.com/_astro/attribute-statements.CXJ3Jtln_jMOU2.webp)

How to receive these SAML attributes in Cloudflare:

![Configure Cloudflare to receive SAML attributes](https://developers.cloudflare.com/_astro/attributes-cloudflare.Dpoa5y0H_Z29p53r.webp)

#### SAML headers

If an application specifically requires SAML attributes upon sign-in, then the attributes can be passed as headers. The **Attribute name** should be the value coming from your IdP (for example, `department`). You can assign any **Header name** to the attribute. The header name will appear in the response headers when Access makes the initial authorization request to `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback`.

#### Multi-record SAML attributes

Cloudflare Access extends support for multi-record SAML attributes such as groups. These attributes are parsed out and can be individually referenced in policies. This feature enables granular access control and precise user authorization in applications.

Cloudflare Access does not currently support partial attribute value references.
