---
title: Workers automatic tracing, now in open beta · Changelog
description: Gain instant visibility into Workers execution with automatic
  tracing and OpenTelemetry exports
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-11-07-automatic-tracing/
  md: https://developers.cloudflare.com/changelog/2025-11-07-automatic-tracing/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Workers automatic tracing, now in open beta

Nov 07, 2025

[Workers](https://developers.cloudflare.com/workers/)

Enable automatic tracing on your Workers, giving you detailed metadata and timing information for every operation your Worker performs.

![Tracing example](https://developers.cloudflare.com/_astro/R2_Screenshot.DAnOidMq_Deoqf.webp)

Tracing helps you identify performance bottlenecks, resolve errors, and understand how your Worker interacts with other services on the Workers platform. You can now answer questions like:

* Which calls are slowing down my application?
* Which queries to my database take the longest?
* What happened within a request that resulted in an error?

**You can now:**

* View traces alongside your logs in the Workers Observability dashboard
* Export traces (and correlated logs) to any [OTLP-compatible destination](https://opentelemetry.io/docs/specs/otel/protocol/), such as [Honeycomb](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/honeycomb/), [Sentry](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/sentry/) or [Grafana](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/grafana-cloud/), by configuring a tracing destination in the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/workers-and-pages/observability/destinations)
* Analyze and query across span attributes (operation type, status, duration, errors)

#### To get started, set:

```jsonc
{
  "observability": {
    "tracing": {
      "enabled": true,
    },
  },
}
```

Note

In the future, Cloudflare plans to enable automatic tracing in addition to logs when you set `observability.enabled = true` in your Wrangler configuration.

While automatic tracing is in early beta, this setting will not enable tracing by default, and will only enable logs.

An updated [`compatibility_date`](https://developers.cloudflare.com/workers/configuration/compatibility-dates/) will be required for this change to take effect.

#### Want to learn more?

* [Read the announcement](https://blog.cloudflare.com/workers-tracing-now-in-open-beta/)
* [Check out the documentation](https://developers.cloudflare.com/workers/observability/traces/)
